//package globalExamples;

import oracle.olapi.data.source.DataProvider;

import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

import oracle.olapi.metadata.mtm.MtmColumnExpression;
import oracle.olapi.metadata.mtm.MtmLevelHierarchyMap;
import oracle.olapi.metadata.mtm.MtmRdbmsTableOrView;

import java.util.List;
import java.util.Iterator;

/**
 * Complete code for Example 5-1, Getting the Columns for an
 * MtmLevelHierarchyMap, in Chapter 5, Working with Metadata
 * Mapping Objects, in the Oracle OLAP Developer's Guide to the
 * OLAP API.
 *
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 *
 * @author Oracle Corporation
 */
public class GettingColumnsForLevel
{
  public GettingColumnsForLevel()
  {
  }

  public void run(String [] args)
  {
    Context10g context = new Context10g(args, false);


    context.println("Example 5-1, Getting the Columns for an " +
                    "MtmLevelHierarchyMap");

    MdmPrimaryDimension mdmProdDim =
                          context.getMdmPrimaryDimensionByName("PRODUCT");
    MdmLevelHierarchy mdmProdHier =
                       (MdmLevelHierarchy) mdmProdDim.getDefaultHierarchy();

    // The following appears in Example 5-1
    MtmLevelHierarchyMap mtmProdHierMap =
                (MtmLevelHierarchyMap) mdmProdHier.getLevelHierarchyMap();
    MtmRdbmsTableOrView mtmRdbmsTableOrView =
                          (MtmRdbmsTableOrView) mtmProdHierMap.getTable();

    context.println("The name of the table is "
                    + mtmRdbmsTableOrView.getName());

    List mdmProdColumns = mtmRdbmsTableOrView.getColumns();
    Iterator mdmProdColItr = mdmProdColumns.iterator();
    context.println("Its columns are:");
    while (mdmProdColItr.hasNext())
    {
      MtmColumnExpression mtmColExp = (MtmColumnExpression) mdmProdColItr.next();
      context.println(mtmColExp.getColumnName());
    }
  }

  public static void main(String[] args)
  {
    new GettingColumnsForLevel().run(args);
  }
}
